/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.CuodActions;
import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.command.HMCFormatTable;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.GeneralUtil;
import com.ibm.websm.diagnostics.IDebug;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class CuodList
implements HMCCommands {
    private static final String ORDER_INFO = "order";
    private static final String REGULAR_INFO = "reg";
    private static final String CAP_COND_IN_USE = "128";
    private static final String CAP_COND_NOT_IN_USE = "1";
    private static final String CAP_COND_NOT_AVAILABLE = "255";
    private static final String CUOD_INFO = "cuod";
    private static final String ONOFF_INFO = "onoff";
    private static final String ONOFF_CONDITION_AVAILABLE = "0";
    private static final String ONOFF_CONDITION_RUNNING = "1";
    private static final String ONOFF_CONDITION_SUSPENDED = "2";
    private static final String ONOFF_CONDITION_UNAVAILABLE = "3";
    private CuodActions cuodHandler;
    private String format;
    private String managedSystem;
    private String resourceType;
    private String capUpgradeType;
    private String type;
    private String capacityCardCCIN;
    private String capacityCardId;
    private String capacityCardSerialNum;
    private String cpuActivated;
    private String cpuCapacityCond;
    private String cpuDaysHours;
    private String cpuEntryCheck;
    private String cpuSeqNum;
    private String immedCpu;
    private String immedMem;
    private String installedCpu;
    private String installedMem;
    private String memActivated;
    private String memCapacityCard;
    private String memDaysHours;
    private String memEntryCheck;
    private String memSeqNum;
    private String notPermCpu;
    private String notPermMem;
    private String permCpu;
    private String permMem;
    private String resourceId;
    private String systemType;
    private String systemSerialNum;
    private String deconfiguredCpu;
    private String onOffCpuInUse;
    private String onOffCpuRequested;
    private String onOffDays;
    private String onOffHours;
    private String onOffCapacityCond;
    private String onoffCpuOrdered;
    private Hashtable resultTable;
    private HSCCECClient hcc;

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (null == this.capUpgradeType || null == this.resourceType || null == this.type) {
            objectArray = new String[]{HMCCommandUtils.CAPACITY_UPGRADE_TYPE_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.TYPE_PARAM};
            string = new String("The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.CAPACITY_UPGRADE_TYPE_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + " and " + " " + HMCCommandUtils.TYPE_PARAM + ". Please check your entry and retry the command.");
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (!this.capUpgradeType.equals(CUOD_INFO) && !this.capUpgradeType.equals(ONOFF_INFO)) {
            objectArray = new String[]{HMCCommandUtils.CAPACITY_UPGRADE_TYPE_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.TYPE_PARAM};
            string = new String("The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.CAPACITY_UPGRADE_TYPE_PARAM + ", " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + " and " + " " + HMCCommandUtils.TYPE_PARAM + ". Please check your entry and retry the command.");
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (!this.resourceType.equals(HMCCommandUtils.CPU_TYPE) && !this.resourceType.equals(HMCCommandUtils.MEMORY_TYPE)) {
            objectArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "RESOURCE_TYPE", "resource type", null), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "RESOURCE_TYPES", "resource types", null), HMCCommandUtils.CPU_TYPE + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.MEMORY_TYPE};
            string = "The command entered contains an invalid resource type. The valid resource types are " + HMCCommandUtils.CPU_TYPE + " and " + HMCCommandUtils.MEMORY_TYPE + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_VALUE", string, objectArray);
            throw new HSCException(string2);
        }
        if (!this.type.equals(REGULAR_INFO) && !this.type.equals(ORDER_INFO)) {
            objectArray = new String[]{HSCResourceBundleUtil.getMessage("HSCCommonBundle", "LISTING_TYPE", "resource type", null), HSCResourceBundleUtil.getMessage("HSCCommonBundle", "LISTING_TYPES", "resource types", null), "reg " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + ORDER_INFO};
            string = "The command entered contains an invalid listing type. The valid listing types are reg and order. Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_VALUE", string, objectArray);
            throw new HSCException(string);
        }
    }

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        Object var2_2 = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
        if (null == this.hcc) {
            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
            throw new HSCException(string);
        }
        this.cuodHandler = this.hcc.getCuodActionHandler();
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        this.format = (String)hashMap.get(HMCCommandUtils.FORMAT_PARAM);
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.type = (String)hashMap.get(HMCCommandUtils.TYPE_PARAM);
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        this.capUpgradeType = (String)hashMap.get(HMCCommandUtils.CAPACITY_UPGRADE_TYPE_PARAM);
    }

    private void printMemoryInfoResults(Hashtable hashtable) {
        HMCFormatTable hMCFormatTable = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Object var9_9 = null;
        String[] stringArray = null;
        if (hashtable == null || hashtable.size() == 0) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            String[] stringArray2;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(6);
                stringArray = new String[]{CuodList.getMessage("IMMED_MEM", "ImmedInUseMem(GB)"), CuodList.getMessage("INSTALLED_MEM", "InstalledMem(GB)"), CuodList.getMessage("MEM_CAPACITY_COND", "MemCapacityCondition"), CuodList.getMessage("DAYS_HOURS", "TimeLeft(Days/Hours)"), CuodList.getMessage("NOT_PERM_MEM", "PermNotActivatedMem(GB)"), CuodList.getMessage("PERM_MEM", "PermanentlyUsedMem(GB)")};
                hMCFormatTable.addEntry(stringArray);
            }
            string = (String)hashtable.get("CUOD_AMOUNT_MEM_IMMED_IN_USED");
            string2 = (String)hashtable.get("CUOD_AMOUNT_MEM_INSTALLED");
            string3 = (String)hashtable.get("CUOD_MEM_ACT_IMMED_CONDITION");
            string4 = (String)hashtable.get("CUOD_MEM_ACT_IMMED_TIME_REMAINING");
            string5 = (String)hashtable.get("CUOD_AMOUNT_MEM_NOT_PERM_IN_USED");
            string6 = (String)hashtable.get("CUOD_AMOUNT_MEM_PERM_IN_USED");
            string4 = GeneralUtil.getTimeFormatted(string4);
            string3 = string3.equals(CAP_COND_IN_USE) ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CUOD_CAPACITY_CONDITION_IN_USE", "In Use", null) : (string3.equals("1") ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CUOD_CAPACITY_CONDITION_NOT_IN_USE", "Not In Use", null) : (string3.equals(CAP_COND_NOT_AVAILABLE) ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CUOD_CAPACITY_CONDITION_NOT_AVAILABLE", "Not Available", null) : ""));
            if (null != this.format) {
                stringArray2 = new String[6];
                String[] stringArray3 = new String[6];
                stringArray2[0] = "immed_mem";
                stringArray3[0] = string;
                stringArray2[1] = "installed_mem";
                stringArray3[1] = string2;
                stringArray2[2] = "mem_capacity_cond";
                stringArray3[2] = string3;
                stringArray2[3] = "mem_days_hours";
                stringArray3[3] = string4;
                stringArray2[4] = "not_perm_mem";
                stringArray3[4] = string5;
                stringArray2[5] = "perm_mem";
                stringArray3[5] = string6;
                HMCCommandUtils.printFormatWithInputValues(this.format, stringArray2, stringArray3);
            } else {
                stringArray[0] = string;
                stringArray[1] = string2;
                stringArray[2] = string3;
                stringArray[3] = string4;
                stringArray[4] = string5;
                stringArray[5] = string6;
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.format == null && hMCFormatTable != null) {
                stringArray2 = hMCFormatTable.getTable();
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
        }
    }

    private void printMemoryOrderInfoResults(Hashtable hashtable) {
        HMCFormatTable hMCFormatTable = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var6_6 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String[] stringArray = null;
        if (hashtable == null || hashtable.size() == 0) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            String[] stringArray2;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(9);
                stringArray = new String[]{CuodList.getMessage("CAPACITY_CARD_CCIN", "CCIN"), CuodList.getMessage("CAPACITY_CARD_ID", "CapacityCardID"), CuodList.getMessage("CAPACITY_CARD_SERIAL_NUM", "CapacityCard S/N"), CuodList.getMessage("MEM_ACTIVATED", "MemActivated"), CuodList.getMessage("MEM_ENTRY_CHECK", "MemEntryCheck"), CuodList.getMessage("MEM_SEQ_NUM", "MemSeqNum"), CuodList.getMessage("RESOURCE_ID", "ResourceID"), CuodList.getMessage("SYSTEM_TYPE", "SystemType"), CuodList.getMessage("SYSTEM_SERIAL_NUM", "System S/N")};
                hMCFormatTable.addEntry(stringArray);
            }
            string = (String)hashtable.get("CUOD_CAPACITY_CARD_CCIN");
            string2 = (String)hashtable.get("CUOD_CAPACITY_CARD_UNIQUE_ID");
            string3 = (String)hashtable.get("CUOD_CAPACITY_CARD_SERIAL_NUM");
            string4 = (String)hashtable.get("CUOD_MEM_ACTIVATED");
            string5 = (String)hashtable.get("CUOD_MEM_ENTRY_CHECK");
            string6 = (String)hashtable.get("CUOD_MEM_SEQ_NUM");
            string7 = (String)hashtable.get("CUOD_MEM_RESOURCE_ID");
            string8 = (String)hashtable.get("CUOD_SYSTEM_TYPE");
            string9 = (String)hashtable.get("CUOD_SYSTEM_SERIAL_NUM");
            if (null != this.format) {
                stringArray2 = new String[9];
                String[] stringArray3 = new String[9];
                stringArray2[0] = "capacity_card_ccin";
                stringArray3[0] = string;
                stringArray2[1] = "capacity_card_id";
                stringArray3[1] = string2;
                stringArray2[2] = "capacity_card_serial_num";
                stringArray3[2] = string3;
                stringArray2[3] = "mem_activated";
                stringArray3[3] = string4;
                stringArray2[4] = "mem_entry_check";
                stringArray3[4] = string5;
                stringArray2[5] = "mem_seq_num";
                stringArray3[5] = string6;
                stringArray2[6] = "resource_id";
                stringArray3[6] = string7;
                stringArray2[7] = "system_type";
                stringArray3[7] = string8;
                stringArray2[8] = "system_serial_num";
                stringArray3[8] = string9;
                HMCCommandUtils.printFormatWithInputValues(this.format, stringArray2, stringArray3);
            } else {
                stringArray[0] = string;
                stringArray[1] = string2;
                stringArray[2] = string3;
                stringArray[3] = string4;
                stringArray[4] = string5;
                stringArray[5] = string6;
                stringArray[6] = string7;
                stringArray[7] = string8;
                stringArray[8] = string9;
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.format == null && hMCFormatTable != null) {
                stringArray2 = hMCFormatTable.getTable();
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
        }
    }

    private void printCPUInfoResults(Hashtable hashtable) {
        HMCFormatTable hMCFormatTable = null;
        String string = null;
        String string2 = null;
        Object var5_5 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String[] stringArray = null;
        if (hashtable == null || hashtable.size() == 0) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            String[] stringArray2;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(6);
                stringArray = new String[]{CuodList.getMessage("IMMED_CPU", "ImmedInUseCPU"), CuodList.getMessage("INSTALLED_CPU", "InstalledCPU"), CuodList.getMessage("CPU_CAPACITY_COND", "CPUCapacityCond"), CuodList.getMessage("DAYS_HOURS", "TimeLeft(Days/Hours)"), CuodList.getMessage("NOT_PERM_CPU", "NotPermUsedCPU"), CuodList.getMessage("PERM_CPU", "PermUsedCPU")};
                hMCFormatTable.addEntry(stringArray);
            }
            string = (String)hashtable.get("CUOD_CPU_ACT_IMMED_CONDITION");
            string2 = (String)hashtable.get("CUOD_CPU_ACT_IMMED_TIME_REMAINING");
            string3 = (String)hashtable.get("CUOD_NUM_CPU_INSTALLED");
            string4 = (String)hashtable.get("CUOD_NUM_CPU_IMMED_IN_USED");
            string5 = (String)hashtable.get("CUOD_NUM_CPU_NOT_PER_IN_USED");
            string6 = (String)hashtable.get("CUOD_NUM_CPU_PER_IN_USED");
            string2 = GeneralUtil.getTimeFormatted(string2);
            string = string.equals(CAP_COND_IN_USE) ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CUOD_CAPACITY_CONDITION_IN_USE", "In Use", null) : (string.equals("1") ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CUOD_CAPACITY_CONDITION_NOT_IN_USE", "Not In Use", null) : (string.equals(CAP_COND_NOT_AVAILABLE) ? HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CUOD_CAPACITY_CONDITION_NOT_AVAILABLE", "Not Available", null) : ""));
            if (null != this.format) {
                stringArray2 = new String[6];
                String[] stringArray3 = new String[6];
                stringArray2[0] = "cpu_capacity_cond";
                stringArray3[0] = string;
                stringArray2[1] = "cpu_days_hours";
                stringArray3[1] = string2;
                stringArray2[2] = "immed_cpu";
                stringArray3[2] = string4;
                stringArray2[3] = "installed_cpu";
                stringArray3[3] = string3;
                stringArray2[4] = "not_perm_cpu";
                stringArray3[4] = string5;
                stringArray2[5] = "perm_cpu";
                stringArray3[5] = string6;
                HMCCommandUtils.printFormatWithInputValues(this.format, stringArray2, stringArray3);
            } else {
                stringArray[0] = string4;
                stringArray[1] = string3;
                stringArray[2] = string;
                stringArray[3] = string2;
                stringArray[4] = string5;
                stringArray[5] = string6;
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.format == null && hMCFormatTable != null) {
                stringArray2 = hMCFormatTable.getTable();
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
        }
    }

    private void printCPUOrderInfoResults(Hashtable hashtable) {
        HMCFormatTable hMCFormatTable = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Object var9_9 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String[] stringArray = null;
        if (hashtable == null || hashtable.size() == 0) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            String[] stringArray2;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(9);
                stringArray = new String[]{CuodList.getMessage("CAPACITY_CARD_CCIN", "CCIN"), CuodList.getMessage("CAPACITY_CARD_ID", "CapacityCardID"), CuodList.getMessage("CAPACITY_CARD_SERIAL_NUM", "CapacityCard S/N"), CuodList.getMessage("CPU_ACTIVATED", "CPUActivated"), CuodList.getMessage("CPU_ENTRY_CHECK", "CPUEntryCheck"), CuodList.getMessage("CPU_SEQ_NUM", "CPUSeqNum"), CuodList.getMessage("RESOURCE_ID", "ResourceID"), CuodList.getMessage("SYSTEM_TYPE", "SystemType"), CuodList.getMessage("SYSTEM_SERIAL_NUM", "System S/N")};
                hMCFormatTable.addEntry(stringArray);
            }
            string = (String)hashtable.get("CUOD_CAPACITY_CARD_CCIN");
            string2 = (String)hashtable.get("CUOD_CAPACITY_CARD_UNIQUE_ID");
            string3 = (String)hashtable.get("CUOD_CAPACITY_CARD_SERIAL_NUM");
            string4 = (String)hashtable.get("CUOD_CPU_ACTIVATED");
            string5 = (String)hashtable.get("CUOD_CPU_ENTRY_CHECK");
            string6 = (String)hashtable.get("CUOD_CPU_SEQ_NUM");
            string7 = (String)hashtable.get("CUOD_CPU_RESOURCE_ID");
            string8 = (String)hashtable.get("CUOD_SYSTEM_SERIAL_NUM");
            string9 = (String)hashtable.get("CUOD_SYSTEM_TYPE");
            if (null != this.format) {
                stringArray2 = new String[9];
                String[] stringArray3 = new String[9];
                stringArray2[0] = "capacity_card_ccin";
                stringArray3[0] = string;
                stringArray2[1] = "capacity_card_id";
                stringArray3[1] = string2;
                stringArray2[2] = "capacity_card_serial_num";
                stringArray3[2] = string3;
                stringArray2[3] = "cpu_activated";
                stringArray3[3] = string4;
                stringArray2[4] = "cpu_entry_check";
                stringArray3[4] = string5;
                stringArray2[5] = "cpu_seq_num";
                stringArray3[5] = string6;
                stringArray2[6] = "resource_id";
                stringArray3[6] = string7;
                stringArray2[7] = "system_type";
                stringArray3[7] = string8;
                stringArray2[8] = "system_serial_num";
                stringArray3[8] = string9;
                HMCCommandUtils.printFormatWithInputValues(this.format, stringArray2, stringArray3);
            } else {
                stringArray[0] = string;
                stringArray[1] = string2;
                stringArray[2] = string3;
                stringArray[3] = string4;
                stringArray[4] = string5;
                stringArray[5] = string6;
                stringArray[6] = string7;
                stringArray[7] = string9;
                stringArray[8] = string8;
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.format == null && hMCFormatTable != null) {
                stringArray2 = hMCFormatTable.getTable();
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
        }
    }

    private void printOnOffCPUInfoResults(Hashtable hashtable) {
        HMCFormatTable hMCFormatTable = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        String string = null;
        Object var7_7 = null;
        Object var8_8 = null;
        String string2 = null;
        String[] stringArray = null;
        if (hashtable == null || hashtable.size() == 0) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            String[] stringArray2;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(8);
                stringArray = new String[]{CuodList.getMessage("INSTALLED_CPU", "InstalledCPU"), CuodList.getMessage("DECONFIGURED_CPU", "DeconfiguredCPU"), CuodList.getMessage("PERM_CPU", "PermUsedCPU"), CuodList.getMessage("ONOFF_CPU_INUSE", "OnOffCPU"), CuodList.getMessage("ONOFF_CPU_REQUESTED", "OnOffCPURequested"), CuodList.getMessage("ONOFF_CPU_DAYS", "OnOffCPUDaysLeft"), CuodList.getMessage("ONOFF_CPU_HOURS", "OnOffCPUHoursLeft"), CuodList.getMessage("ONOFF_CPU_CONDITION", "OnOffCPUState")};
                hMCFormatTable.addEntry(stringArray);
            }
            string = (String)hashtable.get("ONOFF_TOTAL_INSTALLED");
            this.deconfiguredCpu = (String)hashtable.get("ONOFF_PROCS_GARDED");
            string2 = (String)hashtable.get("ONOFF_PROCS_PERM_IN_USE");
            this.onOffCpuInUse = (String)hashtable.get("ONOFF_PROCS_IN_USE");
            this.onOffCpuRequested = (String)hashtable.get("ONOFF_PROCS_PREV_ORDERED");
            this.onOffHours = (String)hashtable.get("ONOFF_HOURS_REMAINING");
            this.onOffDays = (String)hashtable.get("ONOFF_DAYS_REMAINING");
            this.onOffCapacityCond = (String)hashtable.get("ONOFF_STATE");
            this.onOffCapacityCond = this.onOffCapacityCond.equals(ONOFF_CONDITION_AVAILABLE) ? HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_STATE_AVAILABLE", "Available") : (this.onOffCapacityCond.equals("1") ? HSCResourceBundleUtil.getMessage("CECBundle", "CEC_RUNNING", "Running") : (this.onOffCapacityCond.equals(ONOFF_CONDITION_SUSPENDED) ? HSCResourceBundleUtil.getMessage("CECBundle", "ONOFF_STATE_SUSPENDED", "Suspended") : (this.onOffCapacityCond.equals(ONOFF_CONDITION_UNAVAILABLE) ? HSCResourceBundleUtil.getMessage("CECBundle", "CEC_STATE_NOT_AVAILABLE", "Not Available") : "")));
            if (null != this.format) {
                stringArray2 = new String[8];
                String[] stringArray3 = new String[8];
                stringArray2[0] = "installed_cpu";
                stringArray3[0] = string;
                stringArray2[1] = "deconfig_cpu";
                stringArray3[1] = this.deconfiguredCpu;
                stringArray2[2] = "perm_cpu";
                stringArray3[2] = string2;
                stringArray2[3] = "onoff_cpu_in_use";
                stringArray3[3] = this.onOffCpuInUse;
                stringArray2[4] = "onoff_cpu_requested";
                stringArray3[4] = this.onOffCpuRequested;
                stringArray2[5] = "onoff_days";
                stringArray3[5] = this.onOffDays;
                stringArray2[6] = "onoff_hours";
                stringArray3[6] = this.onOffHours;
                stringArray2[7] = "onoff_condition";
                stringArray3[7] = this.onOffCapacityCond;
                HMCCommandUtils.printFormatWithInputValues(this.format, stringArray2, stringArray3);
            } else {
                stringArray[0] = string;
                stringArray[1] = this.deconfiguredCpu;
                stringArray[2] = string2;
                stringArray[3] = this.onOffCpuInUse;
                stringArray[4] = this.onOffCpuRequested;
                stringArray[5] = this.onOffDays;
                stringArray[6] = this.onOffHours;
                stringArray[7] = this.onOffCapacityCond;
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.format == null && hMCFormatTable != null) {
                stringArray2 = hMCFormatTable.getTable();
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
        }
    }

    private void printOnOffCPUOrderInfoResults(Hashtable hashtable) {
        HMCFormatTable hMCFormatTable = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Object var9_9 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String[] stringArray = null;
        if (hashtable == null || hashtable.size() == 0) {
            if (null == this.format) {
                System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "NO_RESULTS_FOUND"));
            }
        } else {
            String[] stringArray2;
            if (null == this.format) {
                hMCFormatTable = new HMCFormatTable(9);
                stringArray = new String[]{CuodList.getMessage("CAPACITY_CARD_CCIN", "CCIN"), CuodList.getMessage("CAPACITY_CARD_ID", "CapacityCardID"), CuodList.getMessage("CAPACITY_CARD_SERIAL_NUM", "CapacityCard S/N"), CuodList.getMessage("ONOFF_CPU_PREV_ORDERED", "PrevOrderedCPUUnits"), CuodList.getMessage("ONOFF_CPU_ENTRY_CHECK", "CPUEntryCheck"), CuodList.getMessage("CPU_SEQ_NUM", "CPUSeqNum"), CuodList.getMessage("RESOURCE_ID", "ResourceID"), CuodList.getMessage("SYSTEM_TYPE", "SystemType"), CuodList.getMessage("SYSTEM_SERIAL_NUM", "System S/N")};
                hMCFormatTable.addEntry(stringArray);
            }
            string = (String)hashtable.get("ONOFF_CCIN_ID");
            string2 = (String)hashtable.get("ONOFF_UNIQUE_ID");
            string3 = (String)hashtable.get("ONOFF_CCIN_SERIAL_NUM");
            string4 = (String)hashtable.get("ONOFF_PROCS_PREV_ORDERED");
            string5 = (String)hashtable.get("ONOFF_ENTRY_CHECK");
            string6 = (String)hashtable.get("ONOFF_SEQUENCE_NUM");
            string7 = (String)hashtable.get("ONOFF_RESOURCE_ID");
            string8 = (String)hashtable.get("ONOFF_SYSTEM_SERIAL_NUM");
            string9 = (String)hashtable.get("ONOFF_SYSTEM_TYPE");
            if (null != this.format) {
                stringArray2 = new String[9];
                String[] stringArray3 = new String[9];
                stringArray2[0] = "capacity_card_ccin";
                stringArray3[0] = string;
                stringArray2[1] = "capacity_card_id";
                stringArray3[1] = string2;
                stringArray2[2] = "capacity_card_serial_num";
                stringArray3[2] = string3;
                stringArray2[3] = "onoff_cpus_prev_ordered";
                stringArray3[3] = string4;
                stringArray2[4] = "cpu_entry_check";
                stringArray3[4] = string5;
                stringArray2[5] = "cpu_seq_num";
                stringArray3[5] = string6;
                stringArray2[6] = "resource_id";
                stringArray3[6] = string7;
                stringArray2[7] = "system_type";
                stringArray3[7] = string9;
                stringArray2[8] = "system_serial_num";
                stringArray3[8] = string8;
                HMCCommandUtils.printFormatWithInputValues(this.format, stringArray2, stringArray3);
            } else {
                stringArray[0] = string;
                stringArray[1] = string2;
                stringArray[2] = string3;
                stringArray[3] = string4;
                stringArray[4] = string5;
                stringArray[5] = string6;
                stringArray[6] = string7;
                stringArray[7] = string9;
                stringArray[8] = string8;
                hMCFormatTable.addEntry(stringArray);
            }
            if (this.format == null && hMCFormatTable != null) {
                stringArray2 = hMCFormatTable.getTable();
                int n = 0;
                while (n < stringArray2.length) {
                    System.out.println(stringArray2[n]);
                    ++n;
                }
            }
        }
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.validateParameterValues();
        this.initializeClients();
        if (this.resourceType.equals(HMCCommandUtils.MEMORY_TYPE)) {
            this.doMemoryList();
        } else if (this.resourceType.equals(HMCCommandUtils.CPU_TYPE)) {
            this.doCPUList();
        }
    }

    public void printResults() {
    }

    public void doMemoryList() throws HSCException {
        Hashtable hashtable = null;
        if (this.type.equals(REGULAR_INFO)) {
            hashtable = this.cuodHandler.memoryInfo();
            this.printMemoryInfoResults(hashtable);
        } else if (this.type.equals(ORDER_INFO)) {
            hashtable = this.cuodHandler.cuodMemoryOrderInfo();
            this.printMemoryOrderInfoResults(hashtable);
        }
    }

    public void doCPUList() throws HSCException {
        Hashtable hashtable = null;
        if (this.capUpgradeType.equals(CUOD_INFO)) {
            if (this.type.equals(REGULAR_INFO)) {
                hashtable = this.cuodHandler.processorInfo();
                this.printCPUInfoResults(hashtable);
            } else if (this.type.equals(ORDER_INFO)) {
                hashtable = this.cuodHandler.cuodCPUOrderInfo();
                this.printCPUOrderInfoResults(hashtable);
            }
        } else if (this.capUpgradeType.equals(ONOFF_INFO)) {
            if (this.type.equals(REGULAR_INFO)) {
                hashtable = this.cuodHandler.onoffProcessorInfo();
                this.printOnOffCPUInfoResults(hashtable);
            } else if (this.type.equals(ORDER_INFO)) {
                hashtable = this.cuodHandler.onoffProcessorInfo();
                this.printOnOffCPUOrderInfoResults(hashtable);
            }
        }
    }

    public void printHelp() {
        System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CUOD_LIST_HELP"));
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        CuodList cuodList = new CuodList();
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                cuodList.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    cuodList.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                cuodList.mapParameters(hashMap);
                cuodList.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (IDebug.enabled()) {
                hSCException.printStackTrace();
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (RequiredParameterException requiredParameterException) {
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace();
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            System.out.println(string);
            System.exit(1);
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            System.out.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            System.exit(1);
        }
        System.exit(0);
    }

    private static String getMessage(String string, String string2) {
        return HSCResourceBundleUtil.getMessage("HSCCommonBundle", string, string2);
    }
}

